;;  Programm:      ACM-AKTEIG.LSP
;;  Befehlsaufruf: ACM-AKTEIG
;;  Funktion:      Zeigt aktuelle Zeichnungseinstellungen an und ndert sie ggf.
;;  Autor:         Gerhard Rampf
;;                 Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;                 Liebigstr. 3 A
;;                 86399 Bobingen
;;                 E-Mail: info@geracad.de
;;  Datum:         24.10.2023
;;  Plattform:     Alle AutoCAD-Versionen ab Version 2005
(defun c:acm-akteig ( / aei071 aei177 aie001 aie002 aie003 aie004 aie005 aie006 aie007 aie008 aie009 aie010 aie011 aie012 aie013 aie014 aie015 aie016 aie017 aie018 aie019 aie020 aie021 aie022 aie023 aie024 aie025 aie012 aie026 aie027 aie028 aie029 aie030 aie031 aie032 aie033 aie034 aie035 aie036)
    (defun aie001 (aei001 / aei029 aei030 aei031 aei032 aei033 aei034 aei035 aei036 aei037 aei038 aei039 aei040)
      (setq aei029 (aie005 aei001))
        (while aei029
          (setq aei030 (car aei029))
          (setq aei031 (vl-string-right-trim "\\" (car aei030)))
          (setq aei032 (cadr aei030))
            (while aei032
              (setq aei033 (car aei032))
              (setq aei034 (strcat aei031 "\\" aei033))
                (if (setq aei035 (aie002 aei034))
                  (progn
                    (setq aei036 (car aei035))
                      (while aei036
                        (setq aei037 (car aei036))
                        (setq aei038 (strcase aei037))
                          (if (not (vl-position aei038 aei039))
                            (progn
                              (setq aei039 (cons (strcase aei037) aei039))
                              (setq aei040 (cons (cons aei037 aei034) aei040))
                            )
                          )
                        (setq aei036 (cdr aei036))
                      )
                  )
                )
              (setq aei032 (cdr aei032))
            )
          (setq aei029 (cdr aei029))
        )
        (if aei040
          (list (acad_strlsort (mapcar 'car aei040)) aei040)
          nil
        )
    )
    (defun aie002 (aei002 / aei042 aei043 aei044 aei045 aei046 aei047)
      (if
        (and
          (setq aei041 (findfile aei002))
          (setq aei042 (aie004 aei041))
        )
          (progn
              (while aei042
                (if (= (substr (setq aei043 (car aei042)) 1 1) "*")
                  (progn
                    (setq aei043 (substr aei043 2))
                      (if
                        (and
                          (setq aei044 (car (aie003 aei043 "," 0)))
                          (snvalid aei044)
                        )
                          (progn
                            (setq aei045 (strcase aei044))
                              (if (not (vl-position aei045 aei047))
                                (setq aei046 (cons aei044 aei046))
                              )
                            (setq aei047 (cons (setq aei045 (strcase aei044)) aei047))
                          )
                      )
                  )
                )
                (setq aei042 (cdr aei042))
              )
              (if aei046
                (list aei046 aei041)
                nil
              )
          )
          nil
      )
    )
    (defun aie003 (aei003 aei004 aei005 / aei048 aei049)
      (setq aei003 (vl-string-trim aei004 aei003))
        (if (> aei005 0)
          (setq aei003 (vl-string-trim " " aei003))
        )
        (while (setq aei048 (vl-string-search aei004 aei003))
          (setq aei049 (append aei049 (list (substr aei003 1 aei048))))
          (setq aei003 (vl-string-left-trim aei004 (substr aei003 (1+ aei048))))
        )
      (append aei049 (list aei003))
    )
    (defun aie004 (aei006 / aei050 aei051 aei052 aei046)
      (setq aei050 (findfile aei006))
        (if (not aei050)
          (progn
            (repeat 20
              (setq aei050 (findfile aei006))
            )
          )
        )
        (if aei050
          (progn
            (setq aei051 (open aei050 "r"))
              (while (setq aei052 (read-line aei051))
                (setq aei046 (append aei046 (list aei052)))
              )
              (if aei051
                (setq aei051 (close aei051))
              )
            aei046
          )
        )
    )
    (defun aie005 (aei001 / aei053 aei054 aei055 aei056 aei057)
      (setq aei053 (aie006))
        (while aei053
          (setq aei054 (car aei053))
            (if (setq aei055 (vl-directory-files aei054 "*.lin" 1))
              (progn
                (setq aei056 (aie007 aei055 aei001))
                (setq aei057 (cons (list aei054 aei056) aei057))
              )
            )
          (setq aei053 (cdr aei053))
        )
      aei057
    )
    (defun aie006 ( / aei058 aei059 aei060 aei061)
        (if
          (and
            (setq aei058 (getvar "PRODUCT"))
            (= (type aei058) 'STR)
            (vl-position (setq aei059 (strcase aei058)) '("AUTOCAD" "BRICSCAD" "ZWCAD"))
          )
            (progn
              (if (= aei059 "AUTOCAD")
                (setq aei060 "ACAD")
              )
              (if (= aei059 "BRICSCAD")
                (setq aei060 "BRICSCAD")
              )
              (if (= aei059 "ZWCAD")
                (setq aei060 "ZWCAD")
              )
            )
            (setq aei060 "ACAD")
        )
      (setq aei061 (getenv aei060))
      (aie003 aei061 ";" 1)
    )
    (defun aie007 (aei007 aei005 / aei062 aei063 aei064 aei065)
      (setq aei007 (mapcar 'strcase aei007))
        (while aei007
          (setq aei062 (car aei007))
            (if (vl-string-search "ISO" aei062)
              (setq aei063 (cons aei062 aei063))
              (setq aei064 (cons aei062 aei064))
            )
          (setq aei007 (cdr aei007))
        )
        (if (= aei005 0)
          (setq aei065 (append aei064 aei063))
          (setq aei065 (append aei063 aei064))
        )
      aei065
    )
    (defun aie008 (aei008 / aei066)
      (if (setq aei066 (findfile "ltypeshp.shx"))
        (progn
          (if (= (type (vl-catch-all-apply 'vla-LoadShapeFile (list aei008 aei066))) 'VL-CATCH-ALL-APPLY-ERROR)
            (prompt (strcat "Kann Symboldatei \042ltypeshp.shx\042 in \042" (aie009 aei008) "\042 nicht laden. "))
            (setq aei067 T)
          )
        )
        (setq aei067 nil)
      )
    )
    (defun aie009 (aei008 / aei068 aei069)
      (setq aei068 (vl-string-right-trim "\\" (vla-get-Path aei008)))
      (setq aei069 (vla-get-Name aei008))
      (strcat aei068 "\\" aei069)
    )
    (defun aie010 (aei009 / aei070 aei071 aei072 aei073 aei074 aei075 aei076 aei060 aei029 aei077 aei078 aei079 aei080)
        (if
          (and
            (= (type aei009) 'STR)
            (snvalid aei009)
            (not (tblsearch "LTYPE" aei009))
          )
            (progn
              (setq aei070 (vlax-get-acad-object))
              (setq aei071 (vla-get-ActiveDocument aei070))
              (setq aei072 (vla-get-Linetypes aei071))
                (if
                  (and
                    (not (vl-catch-all-error-p (setq aei073 (vl-catch-all-apply 'vla-get-Preferences (list aei070)))))
                    (not (vl-catch-all-error-p (setq aei074 (vl-catch-all-apply 'vla-get-Files (list aei073)))))
                    (not (vl-catch-all-error-p (setq aei075 (vl-catch-all-apply 'vla-get-SupportPath (list aei074)))))
                  )
                    (setq aei076 (aie003 aei075 ";" 1))
                    (progn
                      (if (setq aei060 (getenv "ACAD"))
                        (setq aei076 (aie003 aei060 ";" 1))
                      )
                      (if
                        (and
                          (not aei076)
                          (setq aei060 (getenv "ZWCAD"))
                        )
                          (setq aei076 (aie003 aei060 ";" 1))
                      )
                    )
                )
                (while aei076
                  (setq aei029 (append aei029 (vl-directory-files (car aei076) "*.lin" 1)))
                  (setq aei076 (cdr aei076))
                )
                (while aei029
                    (if (vl-string-search "iso.lin" (setq aei077 (car aei029)))
                      (setq aei078 (append aei078 (list aei077)))
                      (setq aei079 (append aei079 (list aei077)))
                    )
                  (setq aei029 (cdr aei029))
                )
                (if (< (getvar "MEASUREINIT") 1)
                  (setq aei080 (append aei079 aei078))
                  (setq aei080 (append aei078 aei079))
                )
                (while
                  (and
                    (not (tblsearch "LTYPE" aei009))
                    aei080
                  )
                    (vl-catch-all-apply 'vla-Load (list aei072 aei009 (car aei080)))
                    (setq aei080 (cdr aei080))
                )
              (tblsearch "LTYPE" aei009)
            )
        )
        (if (= (type aei009) 'STR)
          (tblsearch "LTYPE" aei009)
          nil
        )
    )
    (defun aie011 (aei010 aei011 / aei083 aei081 aei082)
      (if
        (and
          (setq aei081 (vl-filename-mktemp "acm.dcl"))
          (setq aei082 (open aei081 "w"))
        )
          (progn
            (if (getvar "CETRANSPARENCY")
              (setq aei083
                (list
                  "setprop"
                  ":dialog{key=\042d_01\042;"
                  ":row{"
                  ":column{"
                  ":spacer{height=0.2;}"
                  (strcat ":text{key=\042tg_01\042;label=\042" (nth aei010 (list "&Farbe" "&Color")) ":\042;}")
                  ":spacer{height=0;}}"
                  ":button{key=\042b_01\042;label=\042...\042;width=0;fixed_width=true;}"
                  ":column{"
                  ":spacer{height=0.1;}"
                  ":image_button{key=\042ib_01\042;width=2.9;fixed_width=true;height=1.3;fixed_height=true;color=dialog_background;}"
                  ":spacer{height=0;}}"
                  ":text{key=\042t_01\042;width=25;fixed_width=true;height=1.1;}}"
                  ":row{"
                  ":column{width=18;"
                  ":text{label=\042&Layer:\042;}}"
                  ":column{width=24;"
                  ":popup_list{key=\042pl_01\042;}}}"
                  ":row{"
                  ":column{width=18;"
                  (strcat ":text{label=\042" (nth aei010 (list "Li&nientyp" "Li&netype")) ":\042;}}")
                  ":column{width=24;"
                  ":popup_list{key=\042pl_02\042;}}}"
                  ":row{"
                  ":column{width=18;"
                  (strcat ":text{label=\042" (nth aei010 (list "L.-Typf&aktor" "L.-Type Sc&ale")) ":\042;}}")
                  ":column{width=24;"
                  ":edit_box{key=\042eb_01\042;allow_accept=true;}}}"
                  ":row{"
                  ":column{width=18;"
                  (strcat ":text{label=\042" (nth aei010 (list "&Glob. L.-Typf." "&Glob. Scale F.")) ":\042;}}")
                  ":column{width=24;"
                  ":edit_box{key=\042eb_02\042;allow_accept=true;}}}"
                  ":row{"
                  ":column{width=18;"
                  (strcat ":text{label=\042" (nth aei010 (list "L&inienstrke" "L&ineweight")) ":\042;}}")
                  ":column{width=24;"
                  ":popup_list{key=\042pl_03\042;}}}"
                  ":row{"
                  ":column{width=18;"
                  (strcat ":text{label=\042" (nth aei010 (list "&Transparenz" "&Transparency")) ":\042;}}")
                  ":column{width=24;"
                  ":popup_list{key=\042pl_04\042;}}}"
                  ":row{"
                  ":column{width=18;"
                  (strcat ":text{label=\042" (nth aei010 (list "Obje&kthhe" "Thic&kness")) ":\042;}}")
                  ":column{width=24;"
                  ":edit_box{key=\042eb_03\042;allow_accept=true;}}}"
                  ":row{"
                  ":column{width=18;"
                  (strcat ":text{label=\042" (nth aei010 (list "&Erhebung" "&Elevation")) ":\042;}}")
                  ":column{width=24;"
                  ":edit_box{key=\042eb_04\042;allow_accept=true;}}}"
                  ":row{"
                  ":column{width=18;"
                  (strcat ":text{label=\042" (nth aei010 (list "Te&xtstil" "Te&xt Style")) ":\042;}}")
                  ":column{width=24;"
                  ":popup_list{key=\042pl_05\042;}}}"
                  ":row{"
                  ":column{width=18;"
                  (strcat ":text{label=\042" (nth aei010 (list "Be&m.-Stil" "Di&m. Style")) ":\042;}}")
                  ":column{width=24;"
                  ":popup_list{key=\042pl_06\042;}}}"
                  ":spacer{height=1;}"
                  ":row{"
                  ":spacer{width=2;}"
                  ":button{key=\042b_02\042;label=\042OK\042;width=18;fixed_width=true;is_default=true;}"
                  (strcat ":button{key=\042b_03\042;label=\042" (nth aei010 (list "Abbrechen" "Cancel")) "\042;width=18;fixed_width=true;is_cancel=true;}")
                  ":spacer{width=2;}}"
                  ":spacer{height=0.1;}"
                    (if (= aei011 1)
                      ":text{key=\042t_02\042;height=1.1;alignment=right;}}"
                      "}"
                    )
                )
              )
              (setq aei083
                (list
                  "setprop"
                  ":dialog{key=\042d_01\042;"
                  ":row{"
                  ":column{"
                  ":spacer{height=0.2;}"
                  (strcat ":text{key=\042tg_01\042;label=\042" (nth aei010 (list "&Farbe" "&Color")) ":\042;}")
                  ":spacer{height=0;}}"
                  ":button{key=\042b_01\042;label=\042...\042;width=0;fixed_width=true;}"
                  ":column{"
                  ":spacer{height=0.1;}"
                  ":image_button{key=\042ib_01\042;width=2.9;fixed_width=true;height=1.3;fixed_height=true;color=dialog_background;}"
                  ":spacer{height=0;}}"
                  ":text{key=\042t_01\042;width=25;fixed_width=true;height=1.1;}}"
                  ":row{"
                  ":column{width=18;"
                  ":text{label=\042&Layer:\042;}}"
                  ":column{width=24;"
                  ":popup_list{key=\042pl_01\042;}}}"
                  ":row{"
                  ":column{width=18;"
                  (strcat ":text{label=\042" (nth aei010 (list "Li&nientyp" "Li&netype")) ":\042;}}")
                  ":column{width=24;"
                  ":popup_list{key=\042pl_02\042;}}}"
                  ":row{"
                  ":column{width=18;"
                  (strcat ":text{label=\042" (nth aei010 (list "L.-Typf&aktor" "L.-Type Sc&ale")) ":\042;}}")
                  ":column{width=24;"
                  ":edit_box{key=\042eb_01\042;allow_accept=true;}}}"
                  ":row{"
                  ":column{width=18;"
                  (strcat ":text{label=\042" (nth aei010 (list "&Glob. L.-Typf." "&Glob. Scale F.")) ":\042;}}")
                  ":column{width=24;"
                  ":edit_box{key=\042eb_02\042;allow_accept=true;}}}"
                  ":row{"
                  ":column{width=18;"
                  (strcat ":text{label=\042" (nth aei010 (list "L&inienstrke" "L&ineweight")) ":\042;}}")
                  ":column{width=24;"
                  ":popup_list{key=\042pl_03\042;}}}"
                  ":row{"
                  ":column{width=18;"
                  (strcat ":text{label=\042" (nth aei010 (list "Obje&kthhe" "Thic&kness")) ":\042;}}")
                  ":column{width=24;"
                  ":edit_box{key=\042eb_03\042;allow_accept=true;}}}"
                  ":row{"
                  ":column{width=18;"
                  (strcat ":text{label=\042" (nth aei010 (list "&Erhebung" "&Elevation")) ":\042;}}")
                  ":column{width=24;"
                  ":edit_box{key=\042eb_04\042;allow_accept=true;}}}"
                  ":row{"
                  ":column{width=18;"
                  (strcat ":text{label=\042" (nth aei010 (list "Te&xtstil" "Te&xt Style")) ":\042;}}")
                  ":column{width=24;"
                  ":popup_list{key=\042pl_05\042;}}}"
                  ":row{"
                  ":column{width=18;"
                  (strcat ":text{label=\042" (nth aei010 (list "Be&m.-Stil" "Di&m. Style")) ":\042;}}")
                  ":column{width=24;"
                  ":popup_list{key=\042pl_06\042;}}}"
                  ":spacer{height=1;}"
                  ":row{"
                  ":spacer{width=2;}"
                  ":button{key=\042b_02\042;label=\042OK\042;width=18;fixed_width=true;is_default=true;}"
                  (strcat ":button{key=\042b_03\042;label=\042" (nth aei010 (list "Abbrechen" "Cancel")) "\042;width=18;fixed_width=true;is_cancel=true;}")
                  ":spacer{width=2;}}"
                  ":spacer{height=0.1;}"
                    (if (= aei011 1)
                      ":text{key=\042t_02\042;height=1.1;alignment=right;}}"
                      "}"
                    )
                )
              )
            )
              (while aei083
                (write-line (car aei083) aei082)
                (setq aei083 (cdr aei083))
              )
            (setq aei082 (close aei082))
            aei081
          )
          nil
      )
    )
    (defun aie012 ( / aei058 aei084)
      (setq aei058 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= aei058 "AUTOCAD")
            (getvar "HPDRAWORDER")
          )
            (setq aei084 T)
            (setq aei084 nil)
        )
        (if (not aei084)
          (alert "\042acm-xxx\042 kann nur unter AutoCAD ab Version 2005 verwendet werden.")
        )
      aei084
    )
    (defun aie013 ( / aei085 aei086 aei088 aei087)
      (setq aei085 (tblnext "LTYPE" T))
      (setq aei086 (cdr (assoc 2 aei085)))
        (if (not (vl-string-search "\174" aei086))
          (setq aei087 (cons aei086 aei087))
        )
        (while (setq aei088 (tblnext "LTYPE"))
          (setq aei086 (cdr (assoc 2 aei088)))
            (if (not (vl-string-search "\174" aei086))
              (setq aei087 (cons aei086 aei087))
            )
          )
      aei087
    )
    (defun aie014 ( / aei089 aei178 aei090)
      (setq aei089 (vla-get-Layers (vla-get-ActiveDocument (vlax-get-acad-object))))
        (vlax-for aei178 aei089
          (if (not (vl-string-search "|" (setq aei069 (vlax-get aei178 'Name))))
            (setq aei090 (cons aei069 aei090))
          )
        )
      (acad_strlsort aei090)
    )
    (defun aie015 (aei007 / aei091 aei092 aei093)
      (if (= (type aei007) 'LIST)
        (progn
          (setq aei007 (aie016 aei007 'STR))
            (if aei007
              (progn
                (setq aei091 aei007)
                  (while aei091
                    (setq aei092 (cons (strcase (car aei091)) aei092))
                    (setq aei091 (cdr aei091))
                  )
                (setq aei092 (reverse aei092))
                (setq aei091 aei092)
                  (while aei091
                      (if (not (vl-position (car aei091) aei093))
                        (setq aei093 (cons (car aei091) aei093))
                      )
                    (setq aei091 (cdr aei091))
                  )
                (setq aei093 (reverse aei093))
              )
            )
        )
      )
      (if aei093
        (aie017 aei093 aei007)
      )
    )
    (defun aie016 (aei007 aei012 / aei094 aei093)
        (repeat (length aei007)
          (setq aei094 (car aei007))
            (if (= (type aei094) aei012)
              (setq aei093 (cons aei094 aei093))
            )
          (setq aei007 (cdr aei007))
        )
      (reverse aei093)
    )
    (defun aie017 (aei013 aei014 / aei095 aei096 aei097 aei098 aei099 aei048 aei093)
      (setq aei095 aei013)
      (setq aei096 aei014)
        (repeat (length aei095)
          (setq aei097 (cons (strcase (car aei095)) aei097))
          (setq aei095 (cdr aei095))
        )
        (repeat (length aei096)
          (setq aei098 (cons (strcase (car aei096)) aei098))
          (setq aei096 (cdr aei096))
        )
      (setq aei097 (reverse aei097))
      (setq aei098 (reverse aei098))
        (repeat (length aei097)
          (setq aei099 (member (car aei097) aei098))
            (if aei099
              (progn
                (setq aei048 (- (length aei098) (length aei099)))
                (setq aei093 (cons (nth aei048 aei014) aei093))
              )
            )
          (setq aei097 (cdr aei097))
        )
      (reverse aei093)
    )
    (defun aie018 (aei010 / aei100)
        (if
          (and
            (setq aei100 (aie013))
            (setq aei101 (car (aie001 1)))
          )
            (progn
              (setq aei102 (append aei100 aei101))
              (setq aei103 (aie015 aei102))
              (setq aei104 (cons (nth aei010 (list "VonLayer" "ByLayer")) (cons (nth aei010 (list "VonBlock" "ByBlock")) (acad_strlsort aei103))))
            )
            (progn
              (if (setq aei105 (tblsearch "LTYPE" "continuous"))
                (setq aei104 (list (nth aei010 (list "VonLayer" "ByLayer")) (nth aei010 (list "VonBlock" "ByBlock")) (cdr (assoc 2 aei105))))
                (setq aei104 (list (nth aei010 (list "VonLayer" "ByLayer")) (nth aei010 (list "VonBlock" "ByBlock"))))
              )
            )
        )
      aei104
    )
    (defun aie019 (aei010 / aei106 aei107 aei108)
      (setq aei106 (list -1 -2 -3 0 5 9 13 15 18 20 25 30 35 40 50 53 60 70 80 90 100 106 120 140 158 200 211))
        (if (< (getvar "LWUNITS") 1)
          (progn
            (setq aei107 (list "_bylayer" "_byblock" "_default" "0.000" "0.002" "0.004" "0.005" "0.006" "0.007" "0.008" "0.010" "0.012" "0.014" "0.016" "0.020" "0.021" "0.024" "0.028" "0.031" "0.035" "0.039" "0.042" "0.047" "0.055" "0.062" "0.079" "0.083"))
            (setq aei108 (list (nth aei010 (list "VonLayer" "ByLayer")) (nth aei010 (list "VonBlock" "ByBlock")) (nth aei010 (list "Vorgabe" "Default")) "0.000''" "0.002''" "0.004''" "0.005''" "0.006''" "0.007''" "0.008''" "0.010''" "0.012''" "0.014''" "0.016''" "0.020''" "0.021''" "0.024''" "0.028''" "0.031''" "0.035''" "0.039''" "0.042''" "0.047''" "0.055''" "0.062''" "0.079''" "0.083''"))
          )
          (progn
            (setq aei107 (list "_bylayer" "_byblock" "_default" "0.00" "0.05" "0.09" "0.13" "0.15" "0.18" "0.20" "0.25" "0.30" "0.35" "0.40" "0.50" "0.53" "0.60" "0.70" "0.80" "0.90" "1.00" "1.06" "1.20" "1.40" "1.58" "2.00" "2.11"))
            (setq aei108 (list (nth aei010 (list "VonLayer" "ByLayer")) (nth aei010 (list "VonBlock" "ByBlock")) (nth aei010 (list "Vorgabe" "Default")) "0.00 mm" "0.05 mm" "0.09 mm" "0.13 mm" "0.15 mm" "0.18 mm" "0.20 mm" "0.25 mm" "0.30 mm" "0.35 mm" "0.40 mm" "0.50 mm" "0.53 mm" "0.60 mm" "0.70 mm" "0.80 mm" "0.90 mm" "1.00 mm" "1.06 mm" "1.20 mm" "1.40 mm" "1.58 mm" "2.00 mm" "2.11 mm"))
          )
        )
      (list aei108 aei107 aei106)
    )
    (defun aie020 (aei015 aei016 / aei109 aei110 aei111)
      (if
        (and
          (= (type aei015) 'STR)
          (= (type aei016) 'LIST)
        )
          (setq aei109 (aie016 aei016 'STR))
      )
      (if aei109
        (progn
          (setq aei110 aei109)
            (while aei110
              (setq aei111 (cons (strcase (car aei110)) aei111))
              (setq aei110 (cdr aei110))
            )
            (if (member (strcase aei015) aei111)
              (list (car (aie017 (list aei015) aei109)) (vl-position (strcase aei015) (reverse aei111)))
              nil
            )
        )
        nil
      )
    )
    (defun aie021 (aei017 aei018 / aei115 aei112 aei113 aei114)
      (setq aei112 (strlen aei017))
        (if (> aei112 aei018)
          (progn
            (setq aei113 (substr aei017 1 (/ (- aei018 3) 2)))
            (setq aei114 (substr aei017 (- aei112 (1- (/ (- aei018 3) 2)))))
            (setq aei115 (strcat aei113 "\056\056\056" aei114))
          )
        )
        (if aei115
          aei115
          aei017
        )
    )
    (defun aie022 (aei019 aei010 / aei116 aei117 aei118 aei119 aei121 aei122 aei123 aei124)
      (setq aei116 (nth (atoi (get_tile "pl_01")) aei019))
      (setq aei117 (entget (tblobjname "LAYER" aei116)))
        (if (assoc 430 aei117)
          (setq aei118 (assoc 430 aei117))
          (progn
            (if (assoc 420 aei117)
              (setq aei118 (assoc 420 aei117))
              (setq aei118 (cons 62 (abs (cdr (assoc 62 aei117)))))
            )
          )
        )
        (if (setq aei119 (acad_truecolordlg (last aei120) T aei118))
          (progn
            (setq aei120 (aie025 aei119))
            (setq aei121 (abs (cdr (assoc 62 aei119))))
              (if
                (and
                  (> aei121 0)
                  (< aei121 256)
                )
                  (progn
                    (if (assoc 430 aei119)
                      (setq aei122 (substr (cdr (assoc 430 aei119)) (+ 2 (vl-string-search "$" (cdr (assoc 430 aei119))))))
                      (progn
                        (if (assoc 420 aei119)
                          (progn
                            (setq aei123 (cdr (assoc 420 aei119)))
                            (setq aei122 (strcat (itoa (lsh (fix aei123) -16)) "," (itoa (lsh (lsh (fix aei123) 16) -24)) "," (itoa (lsh (lsh (fix aei123) 24) -24))))
                          )
                          (progn
                            (if (< aei121 8)
                              (setq aei122 (nth (1- aei121) (nth aei010 (list (list "Rot" "Gelb" "Grn" "Cyan" "Blau" "Magenta" "Wei") (list "Red" "Yellow" "Green" "Cyan" "Blue" "Magenta" "White")))))
                              (setq aei122 (strcat (nth aei010 (list "Farbe " "Color ")) (itoa aei121)))
                            )
                          )
                        )
                      )
                    )
                  )
              )
              (if (= aei121 256)
                (progn
                  (setq aei122 (nth aei010 (list "VonLayer" "ByLayer")))
                  (setq aei124 (nth (atoi (get_tile "pl_01")) aei019))
                  (setq aei125 (entget (tblobjname "LAYER" aei124)))
                  (setq aei121 (abs (cdr (assoc 62 aei125))))
                )
              )
              (if (= aei121 0)
                (progn
                  (setq aei122 (nth aei010 (list "VonBlock" "ByBlock")))
                  (setq aei121 7)
                )
              )
            (set_tile "t_01" (aie021 aei122 21))
            (start_image "ib_01")
            (fill_image 0 0 (dimx_tile "ib_01") (dimy_tile "ib_01") aei121)
            (end_image)
          )
        )
    )
    (defun aie023 (aei010 aei011 / aei126 aei127 aei120 aei128 aei129 aei130 aei131 aei132 aei133 aei134 aei135 aei136 aei137 aei106 aei138 aei139 aei140 aei121 aei122 aei123 aei116 aei117 aei141 aei142 aei143)
        (if (setq aei126 (aie011 aei010 aei011))
          (progn
            (setq aei127 (load_dialog aei126))
              (if (not (new_dialog "setprop" aei127))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list aei126))
            (set_tile "d_01" (nth aei010 (list "Aktuelle Eigenschaften" "Current Properties")))
              (if (= aei011 1)
                (set_tile "t_02" (aie028 (list 9 11 4 8 17 8 4 16 5 10 10 5 22 15 12 12 10 14 18 22 2 11 6 13 1 7 5 22 1 11 19 22 8 11 6 12 20 7 5 13 1 3 1 4 21 4 5)))
              )
            (setq aei120 (aie030))
            (setq aei128 (aie014))
            (setq aei129 (mapcar 'strcase aei128))
            (setq aei130 (aie018 aei010))
            (setq aei131 (mapcar 'strcase aei130))
            (setq aei132 (aie019 aei010))
            (setq aei133 (aie032))
            (setq aei134 (mapcar 'strcase aei133))
            (setq aei135 (car (aie033)))
            (setq aei136 (mapcar 'strcase aei135))
            (start_list "pl_01")
            (mapcar 'add_list aei128)
            (end_list)
            (set_tile "pl_01" (itoa (vl-position (strcase (getvar "CLAYER")) aei129)))
            (start_list "pl_02")
            (mapcar 'add_list aei130)
            (end_list)
            (setq aei137 (getvar "CELTYPE"))
              (if (vl-position (strcase aei137) (list "BYLAYER" "VONLAYER"))
                (set_tile "pl_02" "0")
                (progn
                  (if (vl-position (strcase aei137) (list "BYBLOCK" "VONBLOCK"))
                    (set_tile "pl_02" "1")
                    (set_tile "pl_02" (itoa (vl-position (strcase aei137) aei131)))
                  )
                )
              )
            (start_list "pl_03")
            (mapcar 'add_list (car aei132))
            (end_list)
            (set_tile "pl_03" (itoa (vl-position (getvar "CELWEIGHT") (caddr aei132))))
            (setq aei106 (list -1 -2 -3 0 5 9 13 15 18 20 25 30 35 40 50 53 60 70 80 90 100 106 120 140 158 200 211))
              (if (setq aei138 (getvar "CETRANSPARENCY"))
                (progn
                  (setq aei139 (list -2 -1 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90))
                  (setq aei140 (list (nth aei010 (list "VonBlock" "ByBlock")) (nth aei010 (list "VonLayer" "ByLayer")) "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79" "80" "81" "82" "83" "84" "85" "86" "87" "88" "89" "90"))
                  (start_list "pl_04")
                  (mapcar 'add_list aei140)
                  (end_list)
                  (set_tile "pl_04" (itoa (vl-position aei138 aei139)))
                )
              )
            (start_list "pl_05")
            (mapcar 'add_list aei133)
            (end_list)
            (set_tile "pl_05" (itoa (vl-position (strcase (getvar "TEXTSTYLE")) aei134)))
            (start_list "pl_06")
            (mapcar 'add_list aei135)
            (end_list)
            (set_tile "pl_06" (itoa (vl-position (strcase (getvar "DIMSTYLE")) aei136)))
            (setq aei121 (abs (cdr (assoc 62 aei120))))
              (if
                (and
                  (> aei121 0)
                  (< aei121 256)
                )
                  (progn
                    (if (assoc 430 aei120)
                      (setq aei122 (substr (cdr (assoc 430 aei120)) (+ 2 (vl-string-search "$" (cdr (assoc 430 aei120))))))
                      (progn
                        (if (assoc 420 aei120)
                          (progn
                            (setq aei123 (cdr (assoc 420 aei120)))
                            (setq aei122 (strcat (itoa (lsh (fix aei123) -16)) "," (itoa (lsh (lsh (fix aei123) 16) -24)) "," (itoa (lsh (lsh (fix aei123) 24) -24))))
                          )
                          (progn
                            (if (< aei121 8)
                              (setq aei122 (nth (1- aei121) (nth aei010 (list (list "Rot" "Gelb" "Grn" "Cyan" "Blau" "Magenta" "Wei") (list "Red" "Yellow" "Green" "Cyan" "Blue" "Magenta" "White")))))
                              (setq aei122 (strcat (nth aei010 (list "Farbe " "Color ")) (itoa aei121)))
                            )
                          )
                        )
                      )
                    )
                  )
              )
              (if (= aei121 0)
                (progn
                  (setq aei122 (nth aei010 (list "VonBlock" "ByBlock")))
                  (setq aei121 7)
                )
              )
              (if (= aei121 256)
                (progn
                  (setq aei122 (nth aei010 (list "VonLayer" "ByLayer")))
                  (setq aei121 (cdr (assoc 62 (entget (tblobjname "LAYER" (getvar "CLAYER"))))))
                )
              )
            (set_tile "t_01" (aie021 aei122 21))
            (start_image "ib_01")
            (fill_image 0 0 (dimx_tile "ib_01") (dimy_tile "ib_01") aei121)
            (end_image)
            (set_tile "eb_01" (rtos (getvar "CELTSCALE") 2))
            (set_tile "eb_02" (rtos (getvar "LTSCALE") 2))
            (set_tile "eb_03" (rtos (getvar "THICKNESS")))
            (set_tile "eb_04" (rtos (getvar "ELEVATION")))
            (action_tile "b_01" "(aie022 aei128 aei010)")
            (action_tile "ib_01" "(aie022 aei128 aei010)")
              (action_tile "pl_01" "(if (equal aei120 (list (cons 62 256)))
                    (progn
                      (setq aei116 (nth (atoi $value) aei128))
                      (setq aei117 (entget (tblobjname \"LAYER\" aei116)))
                      (setq aei141 (abs (cdr (assoc 62 aei117))))
                      (start_image \"ib_01\")
                      (fill_image 0 0 (dimx_tile \"ib_01\") (dimy_tile \"ib_01\") aei141)
                      (end_image)
                    ))"
              )
              (action_tile "b_02" "(setq aei142 (aie034 0))
                 (if (< aei142 1)
                   (mode_tile \"eb_01\" 2)
                 )
                 (if (> aei142 0)
                   (progn
                     (setq aei142 (aie034 1))
                       (if (< aei142 1)
                         (mode_tile \"eb_02\" 2)
                       )
                   )
                 )
                 (if (> aei142 0)
                   (progn
                     (setq aei142 (aie034 2))
                       (if (< aei142 1)
                         (mode_tile \"eb_03\" 2)
                       )
                   )
                 )
                 (if (> aei142 0)
                   (progn
                     (setq aei142 (aie034 3))
                       (if (< aei142 1)
                         (mode_tile \"eb_04\" 2)
                       )
                   )
                 )
                 (if (> aei142 0)
                   (progn
                     (setq aei143
                       (list
                         aei120
                         (nth (atoi (get_tile \"pl_01\")) aei128)
                         (nth (atoi (get_tile \"pl_02\")) aei130)
                         (distof (get_tile \"eb_01\"))
                         (distof (get_tile \"eb_02\"))
                         (nth (atoi (get_tile \"pl_03\")) aei106)
                         (distof (get_tile \"eb_03\"))
                         (distof (get_tile \"eb_04\"))
                         (nth (atoi (get_tile \"pl_05\")) aei133)
                         (nth (atoi (get_tile \"pl_06\")) aei135)
                       )
                     )
                       (if (getvar \"CETRANSPARENCY\")
                         (setq aei143 (append aei143 (list (nth (atoi (get_tile \"pl_04\")) aei139))))
                       )
                 (done_dialog)))"
              )
              (action_tile "b_03" "(setq aei143 nil)
                (done_dialog)"
              )
            (start_dialog)
            (unload_dialog aei127)
          )
        )
      aei143
    )
    (defun aie024 (aei020 / aei144 aei145 aei046 aei146 aei147 aei148)
      (setq aei120 (setq aei020 (aie025 aei020)))
      (setq aei144 (length aei020))
        (if (= aei144 1)
          (progn
            (setq aei145 (cdr (assoc 62 aei020)))
              (if (= aei145 0)
                (setq aei046 (list "_color" "_ByBlock"))
              )
              (if (= aei145 256)
                (setq aei046 (list "_color" "_ByLayer"))
              )
              (if (vl-position aei145 (list 1 2 3 4 5 6 7))
                (setq aei046 (list "_color" (nth (1- aei145) (list "_red" "_yellow" "_green" "_cyan" "_blue" "_magenta" "_white"))))
              )
              (if (not aei046)
                (setq aei046 (list "_color" (itoa aei145)))
              )
          )
        )
        (if (= aei144 2)
          (progn
            (setq aei145 (cdr (assoc 420 aei020)))
            (setq aei145 (list (lsh (fix aei145) -16)(lsh (lsh (fix aei145) 16) -24)(lsh (lsh (fix aei145) 24) -24)))
            (setq aei046 (list "_color" "_truecolor" (strcat (itoa (car aei145)) "\054" (itoa (cadr aei145)) "\054" (itoa (caddr aei145)))))
          )
        )
        (if (= aei144 3)
          (progn
            (setq aei145 (cdr (assoc 430 aei020)))
            (setq aei146 (vl-string-search "$" aei145))
            (setq aei147 (substr aei145 1 aei146))
            (setq aei148 (substr aei145 (+ aei146 2)))
            (setq aei046 (list "_color" "_colorbook" aei147 aei148))
          )
        )
      aei046
    )
    (defun aie025 (aei021 / )
      (if
        (and
          (= (length aei021) 3)
          (not (vl-string-search "AUTOCAD" (strcase (getvar "PRODUCT"))))
        )
          (progn
            (alert "ACHTUNG: Es wird die RGB-Entsprechung der gewhlten Farbbuch-Farbe verwendet.")
            (list (car aei021) (cadr aei021))
          )
          aei021
      )
    )
    (defun aie012 ( / aei149)
      (setq aei149 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= aei149 "AUTOCAD")
            (getvar "HPDRAWORDER")
          )
            (setq aei084 T)
            (setq aei084 nil)
        )
        (if (not aei084)
          (alert "\042acm-akteig\042 kann nur unter AutoCAD ab Version 2005 verwendet werden.")
        )
      aei084
    )
    (defun aie026 (aei022 / )
        (if aei177 (setq *error* aei177))
        (if aei153
          (vl-catch-all-apply 'setvar (list "LIMCHECK" aei153))
        )
        (if aei175
          (vl-catch-all-apply 'setvar (list "CMDECHO" aei175))
        )
      (vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
      (princ)
    )
    (defun aie027 (aei023 / )
      (substr "aAcdefgiIlnorsTuv?:@. " aei023 1)
    )
    (defun aie028 (aei024 / aei150)
      (setq aei150 "")
        (while aei024
          (setq aei150 (strcat aei150 (aie027 (car aei024))))
          (setq aei024 (cdr aei024))
        )
      aei150
    )
    (defun aie029 (aei025 / aei151)
      (setq aei151 (aie028 (list 3 4 1 15 5)))
        (if (< (atoi (substr (rtos (getvar aei151) 2 0) 1 6)) aei025)
          0
          1
        )
    )
    (defun aie030 ( / aei071 aei152 aei153 aei156 aei157 aei158 aei159 aei160 aei161 aei154 aei155)
      (setq aei071 (vla-get-ActiveDocument (vlax-get-acad-object)))
        (if (< (getvar "TILEMODE") 1)
          (progn
            (if (= (vla-get-MSpace aei071) :vlax-true)
              (setq aei152 (vla-get-ModelSpace aei071))
              (setq aei152 (vla-get-PaperSpace aei071))
            )
          )
          (setq aei152 (vla-get-ModelSpace aei071))
        )
      (setq aei153 (getvar "LIMCHECK"))
      (setvar "LIMCHECK" 0)
        (if (= (vla-get-Lock (setq aei154 (vlax-ename->vla-object (tblobjname "LAYER" (getvar "CLAYER"))))) :vlax-true)
          (progn
            (setq aei155 1)
            (vla-put-Lock aei154 :vlax-false)
          )
        )
      (vla-AddLine aei152 (vlax-3D-point (list 0.0 0.0 0.0)) (vlax-3D-point (list 0.0 0.0 0.0)))
      (setvar "LIMCHECK" aei153)
      (setq aei156 (entget (setq aei157 (entlast))))
      (entdel aei157)
        (if aei155
          (vla-put-Lock aei154 :vlax-true)
        )
        (if (setq aei158 (assoc 430 aei156))
          (setq aei159 (list (assoc 62 aei156) (assoc 420 aei156) aei158))
          (progn
            (if (setq aei160 (assoc 420 aei156))
              (setq aei159 (list (assoc 62 aei156) aei160))
              (progn
                (if (setq aei161 (assoc 62 aei156))
                  (setq aei159 (list aei161))
                  (setq aei159 (list (cons 62 256)))
                )
              )
            )
          )
        )
      aei159
    )
    (defun aie031 (aei026 / aei162 aei147 aei148)
        (if (not (assoc 420 aei026))
          (setvar "CECOLOR" (itoa (cdr (assoc 62 aei026))))
          (progn
            (if (not (assoc 430 aei026))
              (setvar "CECOLOR" (strcat "RGB:" (caddr (aie024 aei026))))
              (progn
                (setq aei162 (aie024 aei026))
                (setq aei147 (caddr aei162))
                (setq aei148 (cadddr aei162))
                (vl-cmdf "._-color" "_colorbook" aei147 aei148)
              )
            )
          )
        )
      (getvar "CECOLOR")
    )
    (defun aie032 ( / aei163 aei164 aei165 aei166)
      (setq aei163 (tblnext "STYLE" T))
      (setq aei164 (cdr (assoc 2 aei163)))
        (if (not (vl-string-search "\174" aei164))
          (setq aei165 (cons aei164 aei165))
        )
      (setq aei166 (tblnext "STYLE"))
        (while aei166
          (setq aei164 (cdr (assoc 2 aei166)))
            (if (not (vl-string-search "\174" aei164))
              (setq aei165 (cons aei164 aei165))
            )
          (setq aei166 (tblnext "STYLE"))
        )
        (if aei165
          (setq aei165 (acad_strlsort aei165))
        )
        (while (equal (car aei165) "")
          (setq aei165 (cdr aei165))
        )
      aei165
    )
    (defun aie033 ( / aei167 aei168 aei171 aei169 aei170)
      (setq aei167 (tblnext "DIMSTYLE" T))
      (setq aei168 (cdr (assoc 2 aei167)))
        (if (not (vl-string-search "\044" aei168))
          (progn
            (setq aei169 (list aei168))
            (setq aei170 (list (aie021 aei168 15)))
          )
        )
      (setq aei171 (tblnext "DIMSTYLE"))
        (while aei171
          (setq aei168 (cdr (assoc 2 aei171)))
            (if (not (vl-string-search "\044" aei168))
              (progn
                (setq aei169 (cons aei168 aei169))
                (setq aei170 (cons (aie021 aei168 15) aei170))
              )
            )
          (setq aei171 (tblnext "DIMSTYLE"))
        )
        (if aei169
          (setq aei169 (acad_strlsort aei169))
        )
        (if aei170
          (setq aei170 (acad_strlsort aei170))
        )
      (list aei169 aei170)
    )
    (defun aie034 (aei027 / aei172 aei173 aei145 aei174)
      (setq aei172 (list "eb_01" "eb_02" "eb_03" "eb_04"))
      (setq aei173 (get_tile (nth aei027 aei172)))
        (if (not (setq aei145 (distof aei173)))
          (progn
            (alert
              (strcat
                "Ungltige Eingabe fr " (nth aei027 (list "L.-Typfaktor" "Glob. L.-Typfaktor" "Objekthhe" "Erhebung"))
                ". Gltig: "
                (nth aei027 (list "Ganz- oder Gleitkommazahl > 0.0" "Ganz- oder Gleitkommazahl > 0.0" "Ganz- oder Gleitkommazahl" "Ganz- oder Gleitkommazahl"))
              )
            )
            (setq aei174 0)
          )
          (progn
            (if (vl-position aei027 (list 0 1))
              (if (<= aei145 0.0)
                (progn
                  (alert (strcat "Ungltige Eingabe fr " (nth aei027 (list "L.-Typfaktor" "Glob. L.-Typfaktor")) ". Gltig: Ganz- oder Gleitkommazahl > 0.0"))
                  (setq aei174 0)
                )
                (setq aei174 1)
              )
              (setq aei174 1)
            )
          )
        )
      aei174
    )
    (defun aie035 (aei028 / )
      (vl-catch-all-apply 'aie031 (list (nth 0 aei028)))
      (vl-catch-all-apply 'setvar (list "CLAYER" (nth 1 aei028)))
      (aie008 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (aie010 (nth 2 aei028))
      (vl-catch-all-apply 'setvar (list "CELTYPE" (nth 2 aei028)))
      (vl-catch-all-apply 'setvar (list "CELTSCALE" (nth 3 aei028)))
      (vl-catch-all-apply 'setvar (list "LTSCALE" (nth 4 aei028)))
      (vl-catch-all-apply 'setvar (list "CELWEIGHT" (nth 5 aei028)))
      (vl-catch-all-apply 'setvar (list "THICKNESS" (nth 6 aei028)))
      (vl-catch-all-apply 'setvar (list "ELEVATION" (nth 7 aei028)))
      (vl-catch-all-apply 'setvar (list "TEXTSTYLE" (nth 8 aei028)))
      (vl-cmdf "._-dimstyle" "_restore" (nth 9 aei028))
        (if (getvar "CETRANSPARENCY")
          (vl-catch-all-apply 'setvar (list "CETRANSPARENCY" (nth 10 aei028)))
        )
    )
    (defun aie036 ( / aei175 aei176)
      (setq aei175 (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
        (if (setq aei176 (aie023 0 (aie029 202404)))
          (aie035 aei176)
        )
      (setvar "CMDECHO" aei175)
    )
  (if (aie012)
    (progn
      (vl-load-com)
      (setq aei071 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (setq aei177 *error*)
      (setq *error* aie026)
      (vla-EndUndoMark aei071)
      (vla-StartUndoMark aei071)
      (aie036)
        (if aei177
          (setq *error* aei177)
          (setq *error* nil)
        )
      (vla-EndUndoMark aei071)
    )
  )
  (princ)
)
(terpri)
(princ "\nAutoLISP-Tool ACM-AKTEIG (Copyright  2023 Gerhard Rampf) geladen.")
(princ "\nRufen Sie den Befehl mit ACM-AKTEIG auf.")
